/*
 * Reconstruct stereo v0.90             3/21/93
 *
 * Royce Liao  03/21/93
 * I don't have a real C compiler (just Learn C Now)
 *
 * I borrowed a little bit of the code (error codes) from LEARN C_NOW's
 * sample library (CHARCNT.C)  LEARN_C Now is a product of Microsoft Press.
 *
 * This program will take TWO MONO .SND files (8-bit only) and convert
 * them into a SINGLE STEREO .SND file!  Intended for GUS owners.
 *
 * Haven't worked out all the bugs.  For example the counter doesn't always
 * work correctly.
 *
 * Because of the way I structured the central loop (reading from 2 files)
 * the OUTPUT file will ALWAYS have a length that is a multiple of BUF_SIZE.
 * I'll fix that soon.  I figured it was no big deal.
 *
 * At least, however, you can combine two files of DIFFERENT lengths.
 * The file stream that terminates first will have its corresponding buffer
 * zero'ed.  If you playback the OUTPUT file, one of the channels will
 * become silent before the other.
 */

#include <\work\lc\include\stdio.h>
#include <\work\lc\include\stdlib.h>     /* for exit() prototype */

#define MAXPATH 64
#define BUF_SIZE 256
#define ZERO 128

main(void)
{
	int loop,n, z, n_in[2], end_fl[2]; /* input character */
	FILE *fpin[2], *fpout;               /* file pointer */
	char pathname[2][MAXPATH]; /* filename buffer */
	char outpath[MAXPATH+4];
	char in_buffer[2][BUF_SIZE], out_buffer[BUF_SIZE*2];
	char ch[MAXPATH];
	int flag8=-1, flag2=-1;
	long length_in[2],
	     length_out, skip[2];

	length_out=0;
	length_in[0]=length_in[1]=0;
	end_fl[0]=end_fl[1]=0;

	for (n=0; n<2; ++n)  {
	  printf("INout filename #%d: ",n);
	  scanf("%s",pathname[n]);
	  fpin[n] = fopen(pathname[n], "rb");
	  if (fpin[n] == NULL) {
		fprintf(stderr, "Cannot open %s\n", pathname[n]);
		exit(1);
	     }
	  }

	printf("Outpath: ");  /* Prompt user for output file name */
	scanf("%s",outpath);


	/*  NOT IMPLEMENTED YET!!!  16-bit...maybe I'll make a separate
	do                                                      program...
	{
	   printf("\nConvert to 8-bit or 16-bit (8/16/<n>one) ?");
	   scanf("%s", ch);
	   switch (ch[0]) {
		case '8':
			flag8=8; break;
		case '1':
			flag8=16;
			buf_length/=2;
			break;
		case 'n', 'N':
			flag8=0; break;
		default:
			flag8=-1;
			break;
		}
	}
	while (flag8==-1);        */

	do
	{
	    printf("\nSwitch between 2's complement & unsigned (y/n) ? ");
	    scanf("%s", ch);
	    switch (ch[0]) {
		case 'y': case 'Y':
		     flag2=1;                break;
		case 'n': case 'N':
		     flag2=0;                break;
		default:
		     break;  }
	}
	while (flag2==-1);

	for (n=0; n<2; ++n)  {
	    printf("\nFile %d: Skip how many byte(s) or 0 ? ",n);
	    scanf("%ld", &skip[n]);
	    if (skip[n]!=0)
	       if ( fseek(fpin[n], skip[n], SEEK_SET) != 0 )
		  printf("\nWARNING! Could not seek %ld!",skip[n]);
	       else
		  length_in[n]+=skip[n];
	      /* from beginning of file fpin */
	    }

	/*
	 * Try to open the named file for reading in text mode.
	 * Report any failure to open the file and exit with an
	 * error indication.
	 */

	fpout=fopen(outpath, "wb");

	/*
	 * Read the contents of the file and increment the
	 * character count as each character is read.
	 */

	do      {
		for (z=0; z<2; ++z)  {
		    if (end_fl[z]!=1) {
			n_in[z]=fread(in_buffer[z],sizeof(char),
				      BUF_SIZE,fpin[z]);
			length_in[z]+=n_in[z];
			}

		    if (n_in[z]!=BUF_SIZE && end_fl[z]!=1)
			for (n=n_in[z]; n<BUF_SIZE; ++n)
			    in_buffer[z][n]=ZERO;

		    for (n=0; n<n_in[z]; ++n)
			out_buffer[n*2+z]=in_buffer[z][n];

		    if (n_in[z]!=BUF_SIZE && end_fl[z]!=1)  {
			n_in[z]=BUF_SIZE;
			end_fl[z]=1;
			for (n=0; n<BUF_SIZE; ++n)
			    in_buffer[z][n]=ZERO;
			}
		    }

		if (flag2==1)
		   for (loop=0; loop<BUF_SIZE*2; ++loop)
		       out_buffer[loop]-=128;

		length_out+=fwrite(out_buffer,sizeof(char),
				   BUF_SIZE*2,fpout);

		}
	while ( end_fl[0]==0 || end_fl[1]==0 );


	/*
	 * Report the filename and character count
	 * and close the file.
	 */
	for (n=0; n<2; ++n) {
	    if (fclose(fpin[n]) != 0) {
		fprintf(stderr, "Error closing %s\n",
		   pathname[n]);
		exit(3); }
	    printf("\nFile %s contains %ld characters.\n",
		pathname[n], length_in[n]);
	    }
	printf("\n%ld bytes were written to %s.\n",
		length_out, outpath);

	if (fclose(fpout) !=0) {
		fprintf(stderr, "Error closing %s\n",
			outpath);
		exit(3);
	}

	return (0);
}

/* Everything seems to work...
   I noticed...
	with 2's COMPLEMENT and
	     1 input file shorter than the other... there is a click where
	     the shorter file ends, and another click toward the end.
